<?php $___notjson=1;

class Api {

    public $config;
    private $params; 

    function __construct($config) {
        $this->config = $config;
        $this->params = array(
            'oauth_version' =>  '1.0',
            'oauth_timestamp' => time(),
            'oauth_nonce' => md5(microtime() . mt_rand()),
            'oauth_signature_method' => 'HMAC-SHA1',
            'oauth_consumer_key' => $this->config['consumer_key'],
            'oauth_token' => $this->config['oauth_token'],
            );
    }

    private function getSignature($method, $url, $params) {
        ksort($params);
        $baseString = strtoupper($method) . '&' . urlencode($url) . '&' . urlencode(strtr(http_build_query($params), array ('+' => '%20')));
        return urlencode(base64_encode(hash_hmac('sha1', $baseString, $this->config['consumer_secret'] . '&' . $this->config['oauth_token_secret'], true)));
    }

    private function getBaseName($match) {
        return basename($match[1]);
    }

    public function get($url, $data = array()) {
        $this->params['oauth_nonce'] = md5(microtime() . mt_rand());
        $url = $this->config['url'] . 'uapi' . trim(strtolower($url), '').'';
        $queryString = http_build_query($this->params + $data + array('oauth_signature' => $this->getSignature('GET', $url, $this->params + $data)));
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        //curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_URL, $url . '?' . $queryString);
        $result = curl_exec($curl);
        curl_close($curl);
        return json_decode($result, true);
    }

    public function post($url, $data) {
        $this->params['oauth_nonce'] = md5(microtime() . mt_rand());

        $x=1;
        while ($x<50) {
            if(empty($data['file'.$x])) break;
            $getfile1others = basename($data['file'.$x]);
            $findme = '@';
            $pos = strpos($getfile1others, $findme);
            if ($pos === false) {
                $getfile1shop_array = array(
                    'file'.$x => '@'.$getfile1others
                    );
            } else {
                $getfile1shop_array = array(
                    'file'.$x => ''.$getfile1others
                    );
            }
            unset($data['file'.$x]);
            $data = array_merge($getfile1shop_array, $data);
            $x++;
        }  




        if(!empty($data['file_add_cnt']))  {
            $allcountfilesshop = $data['file_add_cnt'];
        }  

        if ($url == '/shop/editgoods') {

            $i= $allcountfilesshop;
            while ($i<50) {
                if(empty($data['file_add_'.$i]) && $data['file_add_'.$i] != 'file_add_cnt') break;
                $getfile1shop = basename($data['file_add_'.$i]);
                $findme = '@';
                $pos = strpos($getfile1shop, $findme);
                if ($pos === false) {
                    $getfile1shop_array = array(
                        'file_add_'.$i => '@'.$getfile1shop
                        );
                } else {
                    $getfile1shop_array = array(
                        'file_add_'.$i => ''.$getfile1shop
                        );
                }
                unset($data['file_add_'.$i]);
                $data = array_merge($getfile1shop_array, $data);
                $i++;
            }  

        }

        $url = $this->config['url'] . 'uapi' . trim(strtolower($url), '').'/';
        $sign = array('oauth_signature' => $this->getSignature('POST', $url, $this->params + preg_replace_callback('/^@(.+)$/', array($this, 'getBaseName'), $data)));
        $queryString = http_build_query($sign);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        //curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_URL, $url . '?' . $forcurlpost);
        curl_setopt($curl, CURLOPT_POST, true);
        $forcurlpost = array_merge($this->params + $data, $sign);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $forcurlpost);
        $result = curl_exec($curl);
        curl_close($curl);
        return json_decode($result, true);
    }

    public function put($url, $data) {
        $this->params['oauth_nonce'] = md5(microtime() . mt_rand());

        $x=1;
        while ($x<50) {
            if(empty($data['file'.$x])) break;
            $getfile1others = basename($data['file'.$x]);
            $findme = '@';
            $pos = strpos($getfile1others, $findme);
            if ($pos === false) {
                $getfile1shop_array = array(
                    'file'.$x => '@'.$getfile1others
                    );
            } else {
                $getfile1shop_array = array(
                    'file'.$x => ''.$getfile1others
                    );
            }
            unset($data['file'.$x]);
            $data = array_merge($getfile1shop_array, $data);
            $x++;
        }  




        if(!empty($data['file_add_cnt']))  {
            $allcountfilesshop = $data['file_add_cnt'];
        }  

        if ($url == '/shop/editgoods') {

            $i= $allcountfilesshop;
            while ($i<50) {
                if(empty($data['file_add_'.$i]) && $data['file_add_'.$i] != 'file_add_cnt') break;
                $getfile1shop = basename($data['file_add_'.$i]);
                $findme = '@';
                $pos = strpos($getfile1shop, $findme);
                if ($pos === false) {
                    $getfile1shop_array = array(
                        'file_add_'.$i => '@'.$getfile1shop
                        );
                } else {
                    $getfile1shop_array = array(
                        'file_add_'.$i => ''.$getfile1shop
                        );
                }
                unset($data['file_add_'.$i]);
                $data = array_merge($getfile1shop_array, $data);
                $i++;
            }  

        }

        $url = $this->config['url'] . 'uapi' . trim(strtolower($url), '').'/';
        $sign = array('oauth_signature' => $this->getSignature('PUT', $url, $this->params + preg_replace_callback('/^@(.+)$/', array($this, 'getBaseName'), $data)));
        $queryString = http_build_query($sign);
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        //curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_URL, $url . '?' . $queryString);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'PUT');
        $forcurlpost = array_merge($this->params + $data, $sign);
        curl_setopt($curl, CURLOPT_POSTFIELDS, $forcurlpost);
        $result = curl_exec($curl);
        curl_close($curl);
        return json_decode($result, true);
    }

    public function delete($url, $data) {
        $this->params['oauth_nonce'] = md5(microtime() . mt_rand());
        $url = $this->config['url'] . 'uapi' . trim(strtolower($url), '').'/';
        $queryString = http_build_query($this->params + $data + array('oauth_signature' => $this->getSignature('DELETE', $url, $this->params + $data)));
        $curl = curl_init();
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
        //curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1);
        curl_setopt($curl, CURLOPT_URL, $url . '?' . $queryString);
        curl_setopt($curl, CURLOPT_CUSTOMREQUEST, 'DELETE');
        $result = json_decode(curl_exec($curl), true);
        curl_close($curl);
        return json_decode($result, true);
    }

    public function checkResponse($response) {
        if ( isset( $response['error'] ) ) {
            echo $response['error']['msg'];
            exit;
        }
    }

}

?>